/**
 * 
 */
package gov.va.genisis2.bo;

import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;
import gov.va.genisis2.vo.CopyTableSource;

/**
 * @author 586338
 *
 */
public interface IBusiness {
	public ResponseWrapper createStudyApproval(StudyApproval studyApproval);

	public ResponseWrapper getStudyApprovalsByID(int id);

	public ResponseWrapper getStudyApprovalsByUID(String uid);

	public ResponseWrapper getStudyApprovals();

	public ResponseWrapper updateStudyApproval(StudyApproval studyApprovalIn);

	public ResponseWrapper getUserRole(int uid);

	public ResponseWrapper getUserDetailsByEmail(String email);

	public ResponseWrapper getUserDetailsById(int id);

	public ResponseWrapper getRequestDataSources();

	public ResponseWrapper createRequest(Request request);

	public ResponseWrapper getRequestTypes();

	public ResponseWrapper getRequestByID(int id);

	public ResponseWrapper getRequestTrackingByID(int id);

	public ResponseWrapper getRequestsByDataManagers(String uid);
	
	public ResponseWrapper getRequestsDataSourceManagers(String uid);

	public ResponseWrapper getCopyTableDomains();

	public ResponseWrapper getRequestsByUID(String uid);

	public ResponseWrapper getAllRequests();

	public ResponseWrapper getAllRequestsByStudyApproval(int studyApprovalId);

	public ResponseWrapper getAllRequestsByStaus(String status);

	public ResponseWrapper submitOrModify(Request request);

	public ResponseWrapper persist(int id, Request changeRequest, String operation);

	public ResponseWrapper createCommentHistory(CommentHistory commentHistory);

	public ResponseWrapper performTableCopyTransfer(CopyTableSource copyTableSource, int requestId);
}
